# Object actions

This section of the ProBuilder toolbar provides access to ProBuilder editing tools that you can use in the [Object edit mode](modes.md).

![Object mode action buttons on the ProBuilder toolbar](images/tool_objects.png)

> **Note:** Some actions also have extra options or custom settings available. These action buttons have a special indicator in the top right corner. The documentation for each action includes information about these options.

## ![Conform Normals icon](images/icons/Object_ConformNormals.png) Conform Normals

Use the **Conform Normals** action to set all face normals to the same relative direction.

For more information, see the [Conform Normals](Object_ConformNormals.md) action documentation.

## ![Export icon](images/icons/Object_Export.png) Export

Use the **Export** action to [export](workflow-exporting.md#export) the selected ProBuilder object(s) to a 3D Model file. 

For more information, see the [Export](Object_Export.md) action documentation.

## ![Generate UV2 icon](images/icons/Object_LightmapUVs.png) Lightmap UVs

Use the **Lightmap UVs** action to generate any missing lightmap UVs for Meshes.

For more information, see the [Lightmap UVs](Object_LightmapUVs.md) action documentation.

## ![Triangulate icon](images/icons/Object_Triangulate.png) Triangulate

Use the **Triangulate** action to reduce all polygons to their base triangles.

For more information, see the [Triangulate](Object_Triangulate.md) action documentation.

## ![Center Pivot icon](images/icons/CenterPivot.png) Center Pivot

Use the **Center Pivot** action to move the pivot point for the Mesh to the center of the object’s bounds.

For more information, see the [Center Pivot](CenterPivot.md) action documentation.

## ![ProBuilderize icon](images/icons/Object_ProBuilderize.png) ProBuilderize

Use the **ProBuilderize** action to convert the selected object(s) into objects you can edit in ProBuilder.

For more information, see the [ProBuilderize](Object_ProBuilderize.md) action documentation.

## ![Subdivide Object icon](images/icons/Object_Subdivide.png) Subdivide Object

Use the **Subdivide Object** action to divide every face on selected objects.

For more information, see the [Subdivide Object](Object_Subdivide.md) action documentation.

## ![Flip Normals icon](images/icons/Object_FlipNormals.png) Flip Normals

Use the **Flip Normals** action to flip the normals of **all** faces on the selected object(s).

For more information, see the [Flip Normals](Object_FlipNormals.md) action documentation.

## ![Mirror Objects icon](images/icons/Object_Mirror.png) Mirror Objects

Use the **Mirror Objects** action to create mirrored copies of objects.

For more information, see the [Mirror Objects](Object_Mirror.md) action documentation.

## ![Merge Objects icon](images/icons/Object_Merge.png) Merge Objects

Use the **Merge Objects** action to merge two or more selected ProBuilder Meshes.

For more information, see the [Merge Objects](Object_Merge.md) action documentation.


## ![Freeze Transform icon](images/icons/Freeze_Transform.png) Freeze Transform

Use the **Freeze Transform** action to set the selected object's position, rotation, and scale to world-relative origin.

For more information, see the [Freeze Transform](Freeze_Transform.md) action documentation.
